// ShareData.java
// Java class
// Version 1.0

// Cynosure.X International
// 11-10-1997

// Copyright (C) 1997 by Chieh Cheng.
// All Rights Reserved.

// [description]

package plug_ins;

import cynosurex.awt.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class ShareData implements TextListener
{
  private EnhancedTextArea textarea = new EnhancedTextArea ();
  private String           currentFile = "untitled.txt";
  private String           lastDir = null;
  private boolean          edited = false;

  public ShareData ()
  {
    textarea.addTextListener (this);
  }

  public EnhancedTextArea getTextArea ()
  {
    return textarea;
  }

  public void setTextArea (EnhancedTextArea textarea)
  {
    this.textarea = textarea;
    textarea.addTextListener (this);
  }

  public String getFilePath ()
  {
    return currentFile;
  }

  public void setFilePath (String filepath)
  {
    currentFile = filepath;
  }

  public String getFileName ()
  {
    File f = new File (getFilePath ());

    return f.getName ();
  }

  public String getLastDir ()
  {
    return lastDir;
  }

  public void setLastDir (String str)
  {
    lastDir = str;
  }

  public boolean getEdited ()
  {
    return edited;
  }

  protected void setEdited (boolean edited)
  {
    this.edited = edited;
  }

  public void textValueChanged (TextEvent event)
  {
    edited = true;
  }
}
